# TAGLINE

POSIX-standard C99 compiler interface

# TLDR

**Compile a C source file to an executable**

```c99 [file.c] -o [output]```

**Compile without linking (produce object file)**

```c99 -c [file.c]```

**Compile with a library**

```c99 [file.c] -l[library] -o [output]```

**Define a preprocessor macro**

```c99 -D [NAME=value] [file.c] -o [output]```

**Add include directory for headers**

```c99 -I [path/to/includes] [file.c] -o [output]```

**Compile with optimization**

```c99 -O [file.c] -o [output]```

# SYNOPSIS

**c99** [**-c**] [**-D** _name_[=_value_]...] [**-E**] [**-g**] [**-I** _directory_...] [**-L** _directory_...] [**-o** _outfile_] [**-O** _optlevel_] [**-s**] [**-U** _name_...] _operand..._

# DESCRIPTION

**c99** is the POSIX-standard interface to the C compilation system for compiling C99-conformant source code. It compiles C source files and links them to produce an executable file, or can produce object files for later linking.

The command accepts source files (**.c**), object files (**.o**), and library archives (**.a**) as operands. Without the **-o** option, the executable is written to **a.out**.

# PARAMETERS

**-c**
> Compile only; do not link. Produces object files (.o)

**-D** _name_[=_value_]
> Define preprocessor macro

**-E**
> Preprocess only; do not compile

**-g**
> Include debugging information

**-I** _directory_
> Add directory to header search path

**-L** _directory_
> Add directory to library search path

**-l** _library_
> Link with specified library

**-o** _outfile_
> Write output to specified file

**-O** _optlevel_
> Enable optimization (0, 1, 2, 3)

**-s**
> Strip symbols from output

**-U** _name_
> Undefine preprocessor macro

# CAVEATS

The **c99** command may not be available on all systems; it is required only on systems providing the POSIX C-Language Development option. On Linux, it typically invokes **gcc** or **clang** with appropriate flags for C99 compliance.

# HISTORY

The **c99** utility was introduced in **IEEE Std 1003.1-2001** (POSIX.1-2001), based on the earlier **c89** utility from ISO POSIX-2:1993. It reflects updates to support the **ISO/IEC 9899:1999** C standard (C99).

# SEE ALSO

[gcc](/man/gcc)(1), [clang](/man/clang)(1), [make](/man/make)(1), [ld](/man/ld)(1)
