# TAGLINE

Command-line interface for Backblaze B2 cloud storage.

# TLDR

**Authorize** account

```b2 authorize-account [applicationKeyId] [applicationKey]```

**Upload** file

```b2 upload-file [bucketName] [localFile] [remoteFileName]```

**Download** file

```b2 download-file-by-name [bucketName] [fileName] [localFile]```

**List** buckets

```b2 list-buckets```

**Sync** directory

```b2 sync [localPath] b2://[bucketName]/[path]```

# SYNOPSIS

**b2** _command_ [_options_]

# DESCRIPTION

**b2** is the command-line interface for Backblaze B2 Cloud Storage. It provides tools for uploading, downloading, and managing files in B2 buckets, offering S3-compatible object storage at lower costs.

The tool supports large file uploads, versioning, and lifecycle rules.

# PARAMETERS

**authorize-account**
> Authenticate with application key

**upload-file**
> Upload single file

**download-file-by-name**
> Download file by name

**list-buckets**
> List all buckets

**list-file-names**
> List files in bucket

**sync**
> Synchronize directories

**delete-file-version**
> Delete specific file version

**create-bucket**
> Create new bucket

**--threads** _num_
> Number of parallel threads

**--noProgress**
> Disable progress display

# FEATURES

- Large file support (up to 10 TB)
- File versioning
- Server-side encryption
- Lifecycle rules
- S3-compatible API
- Incremental sync

# WORKFLOW

```bash
# Authorize
b2 authorize-account <keyId> <key>

# Create bucket
b2 create-bucket myBucket allPrivate

# Upload directory
b2 sync /local/path b2://myBucket/remote/path

# Download
b2 sync b2://myBucket/path /local/path
```

# CAVEATS

Requires application key with appropriate permissions. Downloads incur bandwidth costs. Deleted files may be retained (versioning). Class C transactions have fees. Sync operations can be slow on first run.

# HISTORY

The **B2 CLI** was released by Backblaze around **2015** alongside the B2 Cloud Storage service as an affordable alternative to Amazon S3.

# SEE ALSO

[aws-s3](/man/aws-s3)(1), [rclone](/man/rclone)(1), [restic](/man/restic)(1)
