# TAGLINE

Analyze and validate IAM policies for security risks

# TLDR

**List** all access analyzers in the current region

```aws accessanalyzer list-analyzers```

**Create** an external access analyzer

```aws accessanalyzer create-analyzer --analyzer-name [name] --type ACCOUNT```

**List** findings generated by an analyzer

```aws accessanalyzer list-findings --analyzer-arn [arn]```

**Get** details about a specific finding

```aws accessanalyzer get-finding --analyzer-arn [arn] --id [finding_id]```

**Create** an archive rule to suppress findings

```aws accessanalyzer create-archive-rule --analyzer-name [name] --rule-name [rule] --filter '[filter_json]'```

**Validate** an IAM policy before deployment

```aws accessanalyzer validate-policy --policy-document [file://policy.json] --policy-type IDENTITY_POLICY```

# SYNOPSIS

**aws accessanalyzer** _command_ [_options_]

# DESCRIPTION

**AWS IAM Access Analyzer** helps you set, verify, and refine IAM policies by providing a comprehensive suite of capabilities for managing identity and resource access in AWS. It uses automated reasoning and logic-based analysis to identify potential security risks and unused access.

The service provides three main types of analyzers:

> **External Access Analyzers** - Identify resources accessible from outside your AWS account or organization, including public internet access and cross-account access. These analyzers use logic-based reasoning to analyze resource-based policies and identify unintended external access before deployment.

> **Internal Access Analyzers** - Identify which principals within your organization or account have access to specific resources. This helps implement the principle of least privilege by ensuring resources are accessible only to intended internal principals.

> **Unused Access Analyzers** - Identify identity access risks by detecting unused resources such as IAM roles, access keys, console passwords, and service or action-level permissions that haven't been used recently.

The tool also provides **policy validation** to check IAM policies for syntax errors and compliance with AWS best practices, plus **policy generation** to automatically create fine-grained policies based on actual access activity captured in CloudTrail logs.

# AVAILABLE COMMANDS

**apply-archive-rule**
> Apply an existing archive rule to findings

**cancel-policy-generation**
> Cancel an in-progress policy generation request

**check-access-not-granted**
> Check that a policy doesn't grant access to specified actions

**check-no-new-access**
> Check that a new policy doesn't grant additional access

**check-no-public-access**
> Check that a policy doesn't allow public access

**create-access-preview**
> Create preview of resource access before deployment

**create-analyzer**
> Create a new analyzer (ACCOUNT, ORGANIZATION, ACCOUNT_UNUSED_ACCESS)

**create-archive-rule**
> Create rule to automatically archive findings

**delete-analyzer**
> Delete an analyzer and its findings

**get-finding**
> Retrieve details about a specific finding

**list-analyzers**
> List all analyzers in the current region

**list-findings**
> Retrieve findings generated by an analyzer

**start-policy-generation**
> Generate IAM policy from CloudTrail activity

**validate-policy**
> Check policy for errors and best practice violations

# CAVEATS

Requires appropriate IAM permissions to create and manage analyzers. External access analyzers at the organization level require AWS Organizations and trusted access. Policy generation requires CloudTrail logging to be enabled. Some findings may take up to 30 minutes to appear after resource changes.

# HISTORY

**AWS IAM Access Analyzer** was announced at **AWS re:Invent 2019** as a service to help identify resources shared with external entities. Over time, it expanded to include unused access analysis, policy validation, and policy generation capabilities, becoming a comprehensive IAM security and governance tool.

# SEE ALSO

[aws-iam](/man/aws-iam)(1), [aws-organizations](/man/aws-organizations)(1), [aws-cloudtrail](/man/aws-cloudtrail)(1), [aws](/man/aws)(1)
