# TAGLINE

terminal-based sliding tile puzzle game

# TLDR

**Start game**

```2048```

**Play with arrow keys**

```Use arrow keys to move tiles```

**Play with vim keys**

```Use h/j/k/l to move tiles```

# SYNOPSIS

**2048**

# CONTROLS

**Arrow keys** or **h/j/k/l** (vim-style)
> Move tiles in that direction

**q**
> Quit game

**r**
> Restart game

# DESCRIPTION

**2048** is a sliding tile puzzle game. The objective is to combine numbered tiles on a 4x4 grid to create a tile with the number 2048.

Gameplay:
- Tiles slide in the chosen direction until they hit the wall or another tile
- Tiles with the same number merge into one with their sum
- After each move, a new tile (2 or 4) appears randomly
- The game ends when no moves are possible

Strategy involves keeping the highest tile in a corner and building up adjacent tiles methodically. The game continues past 2048 if you want to achieve higher scores.

Various terminal implementations exist, including text-based versions in different languages and the original browser game.

# CAVEATS

This is a terminal implementation of the popular puzzle game. Specific features may vary by implementation.

The game requires a terminal that supports the interface (usually ncurses-based).

Strategies that work early game may not scale - higher tiles need more careful planning.

# HISTORY

2048 was created by **Gabriele Cirulli** in **March 2014** as a weekend project. It became viral, spawning countless clones and variations. The concept builds on earlier games like Threes! and 1024.

# SEE ALSO

[snake](/man/snake)(6), [tetris](/man/tetris)(6), [nethack](/man/nethack)(6)
