# TAGLINE

Display images in the terminal

# TLDR

**Display image**

```viu [image.png]```

**Set width**

```viu -w [80] [image.png]```

**Set height**

```viu -h [40] [image.png]```

**Display multiple images**

```viu [image1.png] [image2.png]```

**Use blocks instead of half-blocks**

```viu -b [image.png]```

**Transparent background**

```viu -t [image.png]```

**From stdin**

```cat [image.png] | viu -```

# SYNOPSIS

**viu** [_-w width_] [_-h height_] [_options_] _files_

# PARAMETERS

**-w**, **--width** _N_
> Output width.

**-h**, **--height** _N_
> Output height.

**-b**, **--blocks**
> Use full blocks.

**-t**, **--transparent**
> Transparent background.

**-n**, **--name**
> Show filename.

**-r**, **--recursive**
> Recursive directory.

**-f**, **--frame-rate** _N_
> GIF frame rate.

# DESCRIPTION

**viu** is a terminal image viewer written in Rust that renders images directly in the terminal using Unicode half-block characters and 24-bit ANSI color codes. It supports common image formats including PNG, JPEG, GIF, WebP, and BMP, displaying them at a resolution determined by the terminal's character grid.

Output dimensions can be controlled with width and height options, and aspect ratio is preserved by default when only one dimension is specified. An alternative block rendering mode uses full block characters for a different visual density, and transparent backgrounds can be enabled for images with alpha channels.

Animated GIFs play directly in the terminal with configurable frame rates. The tool also reads from standard input, enabling pipeline integration where images can be fetched with curl or generated by other programs and piped directly to viu for display.

# CAVEATS

Quality depends on terminal. True color support improves output. Large images slow.

# HISTORY

**viu** is a Rust-based terminal image viewer. It provides fast, high-quality image display in modern terminals.

# SEE ALSO

[chafa](/man/chafa)(1), [catimg](/man/catimg)(1), [tiv](/man/tiv)(1)
