# TAGLINE

Tag-based file organization system

# TLDR

**Tag files**

```tmsu tag [file] [tag1] [tag2]```

**List tags**

```tmsu tags```

**Find by tag**

```tmsu files [tag]```

**Find by multiple tags**

```tmsu files [tag1] and [tag2]```

**Untag file**

```tmsu untag [file] [tag]```

**Mount virtual filesystem**

```tmsu mount [mountpoint]```

# SYNOPSIS

**tmsu** _command_ [_options_] [_args_]

# PARAMETERS

**tag**
> Add tags.

**tags**
> List tags.

**files**
> Query files.

**untag**
> Remove tags.

**mount**
> Mount FUSE fs.

**rename**
> Rename tag.

# DESCRIPTION

**tmsu** (Tag My Stuff Unix) is a file tagging tool that lets you organize files by assigning arbitrary tags rather than relying solely on directory hierarchies. Tags and file associations are stored in a local SQLite database, keeping the actual files untouched.

Files can be queried using tag-based expressions with boolean operators (and, or, not), making it easy to find files matching specific criteria. The **mount** command provides a FUSE virtual filesystem where tagged files appear organized into directories by tag, enabling integration with standard file management tools.

# CAVEATS

FUSE needed for mount. Database per directory. Go-based tool.

# HISTORY

**TMSU** (Tag My Stuff Unix) was created for file organization using tags with optional FUSE filesystem support.

# SEE ALSO

[find](/man/find)(1), [locate](/man/locate)(1), [tag](/man/tag)(1)
