# TAGLINE

Default status bar for Sway compositor

# TLDR

**Start swaybar** (usually started by sway)

```swaybar```

**Start with specific bar ID**

```swaybar -b [bar-0]```

**Start with custom config**

```swaybar -c [~/.config/sway/config]```

**Enable debug logging**

```swaybar -d```

# SYNOPSIS

**swaybar** [_options_]

# PARAMETERS

**-b**, **--bar_id** _id_
> Bar ID for which to get the configuration.

**-c**, **--config** _file_
> Path to sway configuration file.

**-d**, **--debug**
> Enable debug logging.

**-h**, **--help**
> Display help message.

**-v**, **--version**
> Display version information.

# DESCRIPTION

**swaybar** is the default status bar for the Sway Wayland compositor. It displays workspace buttons, window titles, and a customizable status area.

The status bar is typically started automatically by Sway based on the bar configuration in the sway config file. The status area content is generated by executing a status_command, which outputs text or JSON to stdout.

Swaybar supports the i3bar JSON protocol for structured status output with colors and click events. It also provides a system tray for applications using the StatusNotifierItem protocol.

Configuration including colors, position, fonts, and behavior is done through the sway configuration file within a bar block.

# CONFIGURATION

Configure in sway config file:

```
bar {
    status_command i3status
    position top
    colors {
        background #323232
        statusline #ffffff
    }
}
```

# CAVEATS

Must be run under Sway compositor. Limited system tray support compared to standalone bars. For advanced customization, consider Waybar as an alternative. Status commands must output data compatible with swaybar or i3bar protocol.

# HISTORY

**swaybar** was developed as part of the Sway project, providing a native Wayland status bar. Sway, created by Drew DeVault, aims for i3 compatibility on Wayland. The bar follows i3bar conventions while operating in a pure Wayland environment without X11 dependencies.

# SEE ALSO

[sway](/man/sway)(1), [i3status](/man/i3status)(1), [waybar](/man/waybar)(1), [i3bar](/man/i3bar)(1)
