# TAGLINE

Convert source code to syntax-highlighted output

# TLDR

**Highlight a source file** to HTML

```source-highlight -i [file.java] -o [file.html]```

**Highlight with automatic language detection**

```source-highlight [file.py]```

**Specify source language** explicitly

```source-highlight -s [cpp] -i [file.cc]```

**Output to a different format**

```source-highlight -f [latex] -i [file.c] -o [file.tex]```

**Highlight multiple files** with pattern

```source-highlight *.java```

**List supported languages**

```source-highlight --lang-list```

**List supported output formats**

```source-highlight --outlang-list```

**Highlight from stdin**

```cat [file.py] | source-highlight -s python```

# SYNOPSIS

**source-highlight** [_options_] [_files_]

# PARAMETERS

**-i**, **--input** _file_
> Input file. Default: stdin.

**-o**, **--output** _file_
> Output file. Default: stdout or input file with appropriate extension.

**-s**, **--src-lang** _lang_
> Source language. If not specified, guessed from file extension.

**-f**, **--out-format** _format_
> Output format (html, xhtml, latex, texinfo, ansi, odt, etc.).

**--style-file** _file_
> Style file for highlighting colors and styles.

**--lang-list**
> List all supported source languages.

**--outlang-list**
> List all supported output formats.

**--lang-def** _file_
> Use custom language definition file.

**--outlang-def** _file_
> Use custom output language definition file.

**-n**, **--line-number**[=_padding_]
> Add line numbers with optional padding width.

**--tab** _n_
> Set tab width (default: 8).

**--title** _string_
> Set document title.

**--css** _file_
> Use CSS file for HTML output.

**-d**, **--doc**
> Create a standalone document.

**-h**, **--help**
> Display help information.

**-V**, **--version**
> Display version information.

# DESCRIPTION

**source-highlight** converts source code files to syntax-highlighted documents in various output formats. It reads language specifications dynamically, making it easily extensible for new programming languages without recompilation.

The tool supports numerous programming languages including C, C++, Java, Python, Perl, Ruby, Shell, and many more. Output formats include HTML, XHTML, LaTeX, ANSI terminal escape sequences, and others.

When processing multiple files using wildcards, output filenames are automatically generated by appending the appropriate extension. The tool can also be used as a CGI script for web-based highlighting or integrated with **less** for automatic syntax highlighting when viewing source files.

# CAVEATS

Requires the Boost regex library. Language detection depends on file extensions; use **-s** for files with non-standard extensions. Custom language and style definitions require familiarity with the definition file format. ANSI output may not display correctly in all terminals.

# HISTORY

**GNU Source-highlight** was created by Lorenzo Bettini and first released in **1999**. It was developed as a flexible, extensible syntax highlighting tool that could support new languages without recompilation. The project is part of the GNU Project and is distributed under the GNU General Public License. Development has continued with support for new languages and output formats.

# SEE ALSO

[highlight](/man/highlight)(1), [pygmentize](/man/pygmentize)(1), [bat](/man/bat)(1)
