# TAGLINE

Automated PHP code refactoring and upgrades

# TLDR

**Run rector**

```vendor/bin/rector process [src/]```

**Dry run**

```vendor/bin/rector process [src/] --dry-run```

**Specific rule**

```vendor/bin/rector process [src/] --config [rector.php]```

**Show available rules**

```vendor/bin/rector list-rules```

**Init configuration**

```vendor/bin/rector init```

**Clear cache**

```vendor/bin/rector process --clear-cache```

**Process single file**

```vendor/bin/rector process [src/File.php]```

# SYNOPSIS

**rector** _command_ [_--dry-run_] [_--config file_] [_options_] [_paths_]

# PARAMETERS

**process**
> Run refactoring.

**init**
> Create config file.

**list-rules**
> Show available rules.

**--dry-run**
> Show changes without applying.

**--config** _FILE_
> Configuration file.

**--clear-cache**
> Clear cache.

**-v**, **--verbose**
> Verbose output.

# DESCRIPTION

**Rector** performs automated refactoring of PHP codebases, applying rule-based transformations to upgrade syntax, modernize framework usage, and enforce code quality standards. It parses PHP files into an abstract syntax tree and applies configured rules to transform old constructs into their modern equivalents, handling PHP version upgrades (e.g., PHP 7.4 to 8.2) and framework migration (Symfony, Laravel, PHPUnit) automatically.

The **--dry-run** flag previews all changes without modifying files, making it safe to review transformations before applying them. Rules are organized into sets for common upgrade paths, and custom rules can be written for project-specific refactoring patterns. The tool is typically configured through a **rector.php** file that specifies which rule sets and individual rules to apply.

# CONFIGURATION

**rector.php**
> Main configuration file defining rule sets, individual rules, paths to process, and skip patterns. Generated by **rector init**.

# CAVEATS

Review dry-run output carefully. Complex code may need manual fixes. Git commit before running.

# HISTORY

**Rector** was created by **Tomas Votruba** for automated PHP refactoring. It enables safe, large-scale codebase modernization.

# SEE ALSO

[phpstan](/man/phpstan)(1), [php-cs-fixer](/man/php-cs-fixer)(1), [phpcs](/man/phpcs)(1)
