# TAGLINE

Reverse engineering and binary analysis framework

# TLDR

**Open binary for analysis**

```r2 [binary]```

**Open in write mode**

```r2 -w [binary]```

**Open with analysis**

```r2 -A [binary]```

**Debug mode**

```r2 -d [binary]```

**Open remote file**

```r2 [gdb://host:port]```

# SYNOPSIS

**r2** [_options_] [_file_]

# PARAMETERS

_FILE_
> Binary file.

**-A**
> Run analysis.

**-w**
> Write mode.

**-d**
> Debug mode.

**-a** _ARCH_
> Architecture.

**-b** _BITS_
> Bits (32/64).

**-c** _CMD_
> Run command.

# DESCRIPTION

**r2** (radare2) is an open-source reverse engineering framework for analyzing, disassembling, debugging, and patching binary files. It supports a wide range of architectures and file formats, providing an interactive command-line shell with hundreds of commands for navigating code, examining data structures, and performing forensic analysis.

The framework includes a built-in disassembler, hex editor, debugger, and scripting engine. The **-A** flag triggers automatic analysis to identify functions, strings, and cross-references on load, while **-d** enables live debugging of running processes. Remote analysis is supported through protocols like GDB, allowing connection to embedded targets and virtual machines. Its plugin system and scripting via Python, JavaScript, and r2pipe make it extensible for custom analysis workflows.

# CAVEATS

Steep learning curve. Powerful but complex.

# HISTORY

radare2 was created as a **reverse engineering** framework.

# SEE ALSO

[gdb](/man/gdb)(1), [objdump](/man/objdump)(1), [ida](/man/ida)(1)

