# TAGLINE

community collection of Nextflow pipelines

# TLDR

**List pipelines**

```nf-core list```

**Download pipeline**

```nf-core download [pipeline-name]```

**Launch pipeline**

```nf-core launch [pipeline-name]```

**Create new pipeline**

```nf-core create```

**Lint pipeline**

```nf-core lint```

**Show pipeline info**

```nf-core info [pipeline-name]```

**Search pipelines**

```nf-core list --search "[keyword]"```

# SYNOPSIS

**nf-core** [_command_] [_options_]

# PARAMETERS

_COMMAND_
> nf-core subcommand.

**list**
> List available pipelines.

**download**
> Download pipeline.

**launch**
> Interactive pipeline launcher.

**create**
> Create new pipeline.

**lint**
> Check pipeline quality.

**--help**
> Display help information.

# DESCRIPTION

**nf-core** is a community collection of Nextflow pipelines. It provides curated bioinformatics workflows.

The tool manages pipeline downloads. Ensures best practices and reproducibility.

# CAVEATS

Python-based CLI. Requires Nextflow. Bioinformatics focus.

# HISTORY

nf-core was established as a **community effort** to standardize and share high-quality Nextflow pipelines.

# SEE ALSO

[nextflow](/man/nextflow)(1), [conda](/man/conda)(1), [docker](/man/docker)(1)

