# TAGLINE

full-stack JavaScript framework

# TLDR

**Create new project**

```meteor create [project-name]```

**Run development server**

```meteor```

**Add package**

```meteor add [package-name]```

**Remove package**

```meteor remove [package-name]```

**Build for production**

```meteor build [output-dir]```

**Deploy to Galaxy**

```meteor deploy [app.meteorapp.com]```

# SYNOPSIS

**meteor** [_command_] [_options_]

# PARAMETERS

_COMMAND_
> Meteor command.

**create** _NAME_
> Create new project.

**add** _PKG_
> Add package.

**remove** _PKG_
> Remove package.

**build** _DIR_
> Build for production.

**deploy** _HOST_
> Deploy application.

**--help**
> Display help information.

# DESCRIPTION

**meteor** is a full-stack JavaScript framework. It builds web and mobile apps with reactive data.

The tool provides real-time updates, hot code push, and integrated build system.

# CAVEATS

Node.js based. MongoDB default. Learning curve for reactivity.

# HISTORY

Meteor was created by **Meteor Development Group** in 2012 as a real-time web application platform.

# SEE ALSO

[node](/man/node)(1), [npm](/man/npm)(1), [mongod](/man/mongod)(1)

