# TAGLINE

manages wordlists for Kiterunner API endpoint discovery

# TLDR

**List available wordlists**

```kr wordlist list```

**Download wordlist**

```kr wordlist download [wordlist-name]```

**Convert wordlist to kite format**

```kr wordlist convert [input.txt] -o [output.kite]```

# SYNOPSIS

**kr** **wordlist** _subcommand_ [_options_]

# PARAMETERS

**list**
> List available wordlists.

**download** _name_
> Download wordlist.

**convert** _input_
> Convert to kite format.

**-o** _file_
> Output file path.

# DESCRIPTION

**kr wordlist** manages wordlists for Kiterunner API endpoint discovery. Provides access to curated API-specific wordlists and tools to convert custom wordlists to the optimized kite format.

# SEE ALSO

[kiterunner-brute](/man/kiterunner-brute)(1)

