# TAGLINE

tiling window manager for X11

# TLDR

**Start i3**

```i3```

**Use custom config**

```i3 -c [~/.config/i3/config]```

**Replace running instance**

```i3 --replace```

**Start with log file**

```i3 --shmlog-size=[10485760]```

**Check version**

```i3 --version```

# SYNOPSIS

**i3** [_options_]

# PARAMETERS

**-c** _FILE_
> Configuration file.

**-a**
> Disable autostart.

**--replace**
> Replace running WM.

**--shmlog-size** _SIZE_
> Shared memory log size.

**-V**
> Verbose mode.

**--version**
> Show version.

**--help**
> Display help information.

# DESCRIPTION

**i3** is a tiling window manager for X11. It organizes windows in a tree structure with workspaces, containers, and layouts.

The window manager uses keyboard-driven navigation and configuration. It supports multi-monitor setups and extensive customization.

# CAVEATS

X11 only. Wayland version is Sway. Configuration learning curve.

# HISTORY

i3 was created by **Michael Stapelberg** in **2009** as an improved tiling window manager focused on simplicity and documentation.

# SEE ALSO

[i3-msg](/man/i3-msg)(1), [i3lock](/man/i3lock)(1), [sway](/man/sway)(1)
