# TAGLINE

command-line Hacker News client

# TLDR

**Browse Hacker News**

```hn```

**Show top stories**

```hn top```

**Show newest stories**

```hn new```

**Show best stories**

```hn best```

**Show ask HN**

```hn ask```

**Open story in browser**

```hn open [story-id]```

# SYNOPSIS

**hn** [_command_] [_options_]

# PARAMETERS

_COMMAND_
> Subcommand to run.

**top**
> Show top stories.

**new**
> Show newest stories.

**best**
> Show best stories.

**ask**
> Show Ask HN posts.

**show**
> Show Show HN posts.

**jobs**
> Show job postings.

**open** _ID_
> Open story in browser.

**--help**
> Display help information.

# DESCRIPTION

**hn** is a command-line Hacker News client. It displays stories, comments, and discussions from the popular tech news aggregator.

The tool provides quick access to different story categories. It can open links and discussions in the default browser.

# CAVEATS

Requires internet connection. Various implementations exist. May need API rate limits.

# HISTORY

Multiple hn CLI tools exist for **Hacker News**, providing terminal access to the popular Y Combinator news site.

# SEE ALSO

[rtv](/man/rtv)(1), [tuir](/man/tuir)(1), [w3m](/man/w3m)(1)
