# TAGLINE

Squash a branch into a single commit

# TLDR

**Squash branch into current**

```git squash [branch]```

**Squash with message**

```git squash [branch] "[message]"```

# SYNOPSIS

**git** **squash** _branch_ [_message_]

# DESCRIPTION

**git squash** merges all commits from a specified branch into the current branch as a single squashed commit. Part of git-extras, it is useful for cleaning up feature branch history before merging into the main branch.

# SEE ALSO

[git-merge](/man/git-merge)(1), [git-rebase](/man/git-rebase)(1), [git-extras](/man/git-extras)(1)
