# TAGLINE

Apply patches to files and the index

# TLDR

**Apply a patch**

```git apply [patch.diff]```

**Check if patch applies**

```git apply --check [patch.diff]```

**Apply with stats**

```git apply --stat [patch.diff]```

**Reverse a patch**

```git apply --reverse [patch.diff]```

**Apply to index**

```git apply --cached [patch.diff]```

# SYNOPSIS

**git apply** [_options_] _patches_

# PARAMETERS

_PATCHES_
> Patch files to apply.

**--check**
> Check if patch applies cleanly.

**--stat**
> Show diffstat instead of applying.

**--reverse**, **-R**
> Apply patch in reverse.

**--cached**
> Apply to index only.

**--3way**
> Attempt 3-way merge.

**-v**, **--verbose**
> Report progress.

**--help**
> Display help information.

# DESCRIPTION

**git apply** applies patches to files and/or the index. Unlike git am, it works with raw diff output without email formatting, making it suitable for patches generated by git diff.

The command can apply patches to the working tree, index, or both. It supports checking patches without applying (--check) and showing statistics (--stat). Reverse application (--reverse) enables undoing patches.

Unlike **git am**, this command does not create commits, making it suitable for applying patches as working directory modifications that can be reviewed before committing.

# CAVEATS

Does not create commits. Use git am for patch series. May fail on binary files without appropriate handling.

# HISTORY

git apply is a core **Git** command for patch application, providing lower-level functionality than git am.

# SEE ALSO

[git-am](/man/git-am)(1), [git-diff](/man/git-diff)(1), [patch](/man/patch)(1)
