# TAGLINE

CoffeeScript compiler and runtime

# TLDR

**Compile a CoffeeScript file** to JavaScript

```coffee -c [script.coffee]```

**Compile and output** to a specific directory

```coffee -c -o [output/] [script.coffee]```

**Watch and compile** files on change

```coffee -w -c [script.coffee]```

**Run a CoffeeScript file** directly

```coffee [script.coffee]```

**Start an interactive REPL**

```coffee```

**Evaluate CoffeeScript code** from command line

```coffee -e "[console.log 'Hello']"```

**Compile all files** in a directory

```coffee -c [src/]```

**Print compiled JavaScript** without saving

```coffee -p [script.coffee]```

# SYNOPSIS

**coffee** [_options_] [_path/to/script.coffee_] [_arguments_]

# PARAMETERS

**-c**, **--compile**
> Compile CoffeeScript to JavaScript files.

**-o** _DIR_, **--output** _DIR_
> Output directory for compiled JavaScript.

**-w**, **--watch**
> Watch files for changes and recompile.

**-p**, **--print**
> Print compiled JavaScript to stdout.

**-e** _CODE_, **--eval** _CODE_
> Evaluate a string of CoffeeScript code.

**-b**, **--bare**
> Compile without the top-level function safety wrapper.

**-m**, **--map**
> Generate source maps alongside JavaScript.

**-M**, **--inline-map**
> Embed source maps within the JavaScript file.

**-n**, **--nodes**
> Print the parse tree (AST) of the source.

**-t**, **--transpile**
> Pipe output through Babel for ES5 compatibility.

**--no-header**
> Suppress the "Generated by CoffeeScript" header.

**-h**, **--help**
> Display help information.

**-v**, **--version**
> Display version information.

# DESCRIPTION

**coffee** is the command-line compiler and runtime for CoffeeScript, a programming language that compiles to JavaScript. CoffeeScript provides a cleaner syntax inspired by Ruby and Python, featuring significant whitespace, implicit returns, and syntactic sugar for common patterns.

The compiler can output JavaScript files, run CoffeeScript directly, or provide an interactive REPL for experimentation. The watch mode enables live development workflows where files are automatically recompiled when saved.

CoffeeScript compiles to readable JavaScript that follows best practices. Source maps allow debugging in the original CoffeeScript even when running the compiled JavaScript. The bare option removes the IIFE wrapper for compatibility with module systems.

# CAVEATS

CoffeeScript 2 outputs modern JavaScript (ES6+) which may require transpilation for older browsers. The significant whitespace requires consistent indentation. Some JavaScript features like async/await have CoffeeScript syntax that differs from JavaScript conventions.

# HISTORY

CoffeeScript was created by Jeremy Ashkenas and released in **December 2009**. It gained significant popularity in the early 2010s, particularly in the Ruby on Rails community. While usage has declined with ES6's adoption of many features CoffeeScript pioneered, it remains maintained and in use.

# SEE ALSO

[node](/man/node)(1), [babel](/man/babel)(1), [tsc](/man/tsc)(1)
