# TAGLINE

Collection of classic BSD Unix text-based games

# TLDR

**Play text adventure game**

```adventure```

**Play Tetris clone**

```tetris-bsd```

**Play Snake game**

```snake```

**Play Worm (snake variant)**

```worm```

**Display random fortune**

```fortune```

**Play hangman**

```hangman```

**Play text-based dungeon crawler**

```hack```

**Play backgammon against computer**

```backgammon```

**Generate random numbers from dice**

```roll [2d6]```

# INCLUDED GAMES

**adventure**
> Classic Colossal Cave text adventure.

**tetris-bsd**
> Terminal-based Tetris clone.

**snake** / **worm**
> Classic snake games.

**hangman**
> Word guessing game.

**hack**
> Precursor to NetHack roguelike.

**backgammon**
> Classic board game.

**battlestar**
> Space-themed text adventure.

**boggle**
> Word search puzzle game.

**canfield** / **cribbage**
> Card games.

**gomoku**
> Five-in-a-row strategy game.

**mille**
> Card-based racing game.

**phantasia**
> Multiplayer fantasy game.

**quiz**
> Educational trivia game.

**robots**
> Strategy game escaping from robots.

**sail**
> Age of sail naval combat.

**trek**
> Star Trek themed strategy game.

# DESCRIPTION

**bsdgames** is a collection of classic text-based games originating from BSD Unix systems. These games represent decades of Unix gaming history, ranging from the earliest text adventures to terminal-based arcade games.

The collection includes puzzle games, card games, board games, text adventures, and action games - all playable in a terminal. Many influenced later games: Adventure pioneered interactive fiction, Hack led to NetHack and roguelikes, and Worm was an early snake game.

Games typically use keyboard controls and ASCII graphics. Most include built-in help accessible via **?** or man pages. Configuration and high scores are often stored in the user's home directory.

# CAVEATS

Some games require a capable terminal emulator. Multiplayer games may not work without additional configuration. The exact games included vary by distribution packaging. Some games have different names on different systems (tetris vs tetris-bsd).

# HISTORY

The BSD games collection evolved alongside Unix at **UC Berkeley** from the **1970s** onward. Many games were contributed by students and staff, becoming part of BSD Unix distributions. The collection represents a snapshot of early computer gaming when terminals were the primary interface. These games were open source before the term existed and have been preserved by the Linux community.

# SEE ALSO

[nethack](/man/nethack)(6), [angband](/man/angband)(6), [fortune](/man/fortune)(6), [cowsay](/man/cowsay)(1)
