# TAGLINE

high-compression file archiver supporting multiple formats

# TLDR

**Create archive**

```7z a [archive.7z] [files...]```

**Extract archive**

```7z x [archive.7z]```

**Extract to specific directory**

```7z x [archive.7z] -o[directory]```

**List archive contents**

```7z l [archive.7z]```

**Test archive integrity**

```7z t [archive.7z]```

**Create with password**

```7z a -p[password] [archive.7z] [files]```

**Create with maximum compression**

```7z a -mx=9 [archive.7z] [files]```

# SYNOPSIS

**7z** _command_ [_switches_] _archive_ [_files_...]

# COMMANDS

**a**
> Add files to archive

**x**
> Extract with full paths

**e**
> Extract (flat, no paths)

**l**
> List archive contents

**t**
> Test archive integrity

**d**
> Delete from archive

**u**
> Update archive

# PARAMETERS

**-o**_dir_
> Output directory (no space after -o)

**-p**_password_
> Set password

**-mx=**_n_
> Compression level (0=store, 9=ultra)

**-t**_type_
> Archive type (7z, zip, tar, gzip, bzip2)

**-mhe=on**
> Encrypt filenames (7z format)

**-r**
> Recurse subdirectories

**-y**
> Assume yes to all queries

**-v**_size_
> Create volumes (e.g., -v100m)

# DESCRIPTION

**7z** is the command-line interface to the 7-Zip archiver, supporting many formats: 7z, ZIP, TAR, GZIP, BZIP2, XZ, and more.

The 7z format offers high compression ratios using LZMA/LZMA2 algorithms, often 30-70% better than ZIP. It also supports AES-256 encryption and multi-volume archives.

Extraction supports many additional formats including RAR, CAB, ISO, and others (read-only for some formats).

# CAVEATS

The 7z format is not as universally supported as ZIP. Consider ZIP for maximum compatibility.

**-o** has no space: **-o/path** not **-o /path**.

RAR creation requires separate RAR tools. 7z can only extract RAR files.

Split archives (**-v**) require all volumes for extraction.

# SEE ALSO

[7za](/man/7za)(1), [7zr](/man/7zr)(1), [tar](/man/tar)(1), [gzip](/man/gzip)(1), [zip](/man/zip)(1)
