# TLDR

**Receive snapshot from file**

```zfs receive [pool/dataset] < [backup.zfs]```

**Receive from remote system**

```ssh [host] zfs send [pool/data@snap] | zfs receive [pool/newdata]```

**Receive with force rollback**

```zfs receive -F [pool/dataset] < [backup.zfs]```

**Receive using full path from stream**

```zfs receive -d [pool] < [backup.zfs]```

**Dry run to test receive**

```zfs receive -nv [pool/dataset] < [backup.zfs]```

**Receive and override properties**

```zfs receive -o mountpoint=[/mnt/data] [pool/dataset] < [backup.zfs]```

**Receive excluding property**

```zfs receive -x compression [pool/dataset] < [backup.zfs]```

**Resume interrupted receive**

```zfs receive -s [pool/dataset] < [backup.zfs]```

# SYNOPSIS

**zfs receive** [_options_] _filesystem_|_volume_|_snapshot_

# PARAMETERS

**-F**
> Force rollback to most recent snapshot before receive.

**-d**
> Use all but first element of sent snapshot path.

**-e**
> Use only last element of sent snapshot path.

**-u**
> Don't mount received filesystem.

**-o** _property=value_
> Set property on received dataset.

**-x** _property_
> Exclude (inherit) property on received dataset.

**-s**
> Enable resumable receive.

**-n**
> Dry run, don't actually receive.

**-v**
> Verbose output.

**-h**
> Skip hold related errors (with -F).

# DESCRIPTION

**zfs receive** (or **zfs recv**) creates a snapshot from a stream provided on stdin. The stream is typically generated by **zfs send**. Full streams create new datasets; incremental streams update existing ones.

For incremental receives, the destination must have the base snapshot. The -F flag forces rollback to enable the receive. Replication streams (-R from send) can destroy extra snapshots at destination.

Properties can be overridden with -o or inherited with -x during receive. This is useful for setting different mount points or compression on the destination.

The -s flag enables resumable receives, allowing interrupted transfers to continue from where they stopped.

# CAVEATS

Incremental stream requires base snapshot at destination. Force (-F) destroys intermediate snapshots. Encrypted raw streams must be received as-is. Property overrides apply to entire subtree for replication streams.

# HISTORY

**zfs receive** has been integral to ZFS since Solaris 10, enabling ZFS replication workflows. OpenZFS enhanced it with resumable receives, property overrides, and better handling of encrypted datasets.

# SEE ALSO

[zfs-send](/man/zfs-send)(8), [zfs-snapshot](/man/zfs-snapshot)(8), [zfs](/man/zfs)(8), [zpool](/man/zpool)(8)
