# TLDR

**Lint JavaScript**

```xo```

**Lint specific files**

```xo [file.js]```

**Fix issues**

```xo --fix```

**Specify space indent**

```xo --space```

**Print config**

```xo --print-config```

# SYNOPSIS

**xo** [_--fix_] [_--space_] [_options_] [_files_]

# PARAMETERS

**--fix**
> Auto-fix issues.

**--space**
> Use space indent.

**--semicolon**
> Require semicolons.

**--prettier**
> Use Prettier.

**--print-config**
> Show config.

# DESCRIPTION

**xo** lints JavaScript. It's opinionated ESLint.

Zero config. Works out of the box.

TypeScript support. Built-in.

Prettier integration. Code formatting.

Strict rules. High quality code.

# CAVEATS

Opinionated rules. Node.js required. ESLint-based.

# HISTORY

**xo** was created by **Sindre Sorhus** as an opinionated ESLint wrapper with sensible defaults.

# SEE ALSO

[eslint](/man/eslint)(1), [standard](/man/standard)(1), [prettier](/man/prettier)(1)
