# TLDR

**Display certificate information**

```openssl x509 -in [certificate.pem] -noout -text```

**Display subject and issuer**

```openssl x509 -in [certificate.pem] -noout -subject -issuer```

**Display certificate dates** (validity period)

```openssl x509 -in [certificate.pem] -noout -dates```

**Display certificate fingerprint**

```openssl x509 -in [certificate.pem] -noout -fingerprint -sha256```

**Convert PEM to DER** format

```openssl x509 -in [cert.pem] -outform DER -out [cert.der]```

**Convert DER to PEM** format

```openssl x509 -in [cert.der] -inform DER -out [cert.pem]```

**Extract public key** from certificate

```openssl x509 -in [certificate.pem] -noout -pubkey```

**Self-sign a certificate request**

```openssl x509 -req -in [request.csr] -signkey [key.pem] -out [certificate.pem]```

# SYNOPSIS

**openssl x509** [**-in** _file_] [**-out** _file_] [**-inform** _DER_|_PEM_] [**-outform** _DER_|_PEM_] [**-noout**] [**-text**] [_options_]

# PARAMETERS

**-in** _file_
> Input certificate file. Reads from stdin if not specified.

**-out** _file_
> Output file. Writes to stdout if not specified.

**-inform** _format_
> Input format: DER or PEM (default).

**-outform** _format_
> Output format: DER or PEM (default).

**-noout**
> Prevent output of the encoded certificate.

**-text**
> Print certificate in human-readable text form.

**-subject**
> Print the certificate subject name.

**-issuer**
> Print the certificate issuer name.

**-dates**
> Print the notBefore and notAfter dates.

**-serial**
> Print the certificate serial number.

**-fingerprint**
> Print certificate fingerprint (use with -sha256, -sha1, etc.).

**-pubkey**
> Output the certificate's public key.

**-req**
> Input is a certificate request, not a certificate.

**-signkey** _file_
> Self-sign using the specified private key.

**-days** _n_
> Validity period in days when signing.

**-CA** _file_
> CA certificate to use for signing.

**-CAkey** _file_
> CA private key for signing.

# DESCRIPTION

**openssl x509** is a multi-purpose certificate utility that displays certificate information, converts between formats, signs certificate requests, and modifies trust settings.

The command operates on X.509 certificates in PEM or DER format. Common operations include viewing certificate details (subject, issuer, validity, extensions), verifying signatures, converting between formats, and certificate signing.

When signing certificates (acting as a mini-CA), it can self-sign using **-signkey** or sign using a CA certificate and key with **-CA** and **-CAkey** options. The **-days** option specifies the validity period.

The command is typically invoked as **openssl x509** rather than standalone **x509**.

# CAVEATS

PEM format is the default and more common for certificate exchange. DER format is binary and cannot contain multiple certificates. When converting formats, ensure the correct -inform is specified. Self-signed certificates may not be trusted by browsers without manual exception.

# HISTORY

The **x509** command has been part of **OpenSSL** since its early releases in the late **1990s**. X.509 is an ITU-T standard for public key infrastructure, first published in **1988** and revised multiple times. The OpenSSL implementation provides comprehensive support for certificate manipulation and has become the standard tool for certificate operations on Unix-like systems.

# SEE ALSO

[openssl](/man/openssl)(1), [openssl-req](/man/openssl-req)(1), [openssl-verify](/man/openssl-verify)(1), [openssl-ca](/man/openssl-ca)(1)
