# TLDR

**Start WordGrinder**

```wordgrinder```

**Open document**

```wordgrinder [document.wg]```

**Import file**

```wordgrinder --import=[file.txt]```

**Export to format**

```wordgrinder --export=[output.html]```

# SYNOPSIS

**wordgrinder** [_--import file_] [_--export file_] [_document_]

# PARAMETERS

**--import** _FILE_
> Import document.

**--export** _FILE_
> Export document.

_document_
> Open document.

# KEY BINDINGS

**Ctrl+S** - Save
**Ctrl+O** - Open
**Ctrl+Q** - Quit
**Ctrl+F** - Find
**Ctrl+R** - Replace
**Ctrl+K** - Style menu
**F1** - Help

# DESCRIPTION

**wordgrinder** is a word processor for the terminal. It focuses on writing, not formatting.

Document structure uses styles. Headings, paragraphs, lists defined.

Distraction-free writing environment. Full screen text editing.

Export to multiple formats. HTML, LaTeX, Markdown, ODT.

Native format preserves structure. .wg files save completely.

Simple but powerful. Focus on content over appearance.

# CAVEATS

Terminal-based, no WYSIWYG. Limited formatting. Specific to prose writing.

# HISTORY

**WordGrinder** was created for focused terminal writing. It provides a distraction-free word processing environment.

# SEE ALSO

[vim](/man/vim)(1), [nano](/man/nano)(1), [joe](/man/joe)(1)
