# TLDR

**List projects**

```wlc ls```

**Show component**

```wlc show [project/component]```

**Download translations**

```wlc download [project/component]```

**Upload translations**

```wlc upload [project/component]```

**Commit changes**

```wlc commit [project/component]```

# SYNOPSIS

**wlc** _command_ [_options_] [_args_]

# PARAMETERS

**ls**
> List projects.

**show**
> Show details.

**download**
> Get translations.

**upload**
> Send translations.

**commit**
> Commit changes.

**--config** _FILE_
> Config file.

# DESCRIPTION

**wlc** controls Weblate. It's the CLI client.

Translation management. Upload/download.

Project listing. Browse translations.

Commit changes. Push to Weblate.

API access. Full control.

# CAVEATS

Weblate server needed. API key required. Python-based.

# HISTORY

**wlc** is the command-line client for **Weblate**, an open-source translation management system.

# SEE ALSO

[weblate](/man/weblate)(1), [poedit](/man/poedit)(1)
