# TLDR

**Install package**

```wapm install [package]```

**Run package**

```wapm run [package]```

**Search packages**

```wapm search [query]```

**Publish package**

```wapm publish```

**Login**

```wapm login```

**List installed**

```wapm list```

# SYNOPSIS

**wapm** _command_ [_options_] [_args_]

# PARAMETERS

**install**
> Install package.

**run**
> Run package.

**search**
> Find packages.

**publish**
> Upload package.

**login**
> Authenticate.

**list**
> Show installed.

# DESCRIPTION

**wapm** manages WebAssembly packages. It's the WAPM CLI.

Package manager for WASM. Install and run.

WebAssembly modules. Cross-platform.

Registry access. wapm.io.

Run anywhere. WASM portability.

# CAVEATS

Wasmer recommended. WASM ecosystem. wapm.io account for publish.

# HISTORY

**wapm** is the package manager for **Wasmer**, providing WebAssembly package management.

# SEE ALSO

[wasmer](/man/wasmer)(1), [wasm-pack](/man/wasm-pack)(1)
