# TLDR

**Deploy application**

```vela up```

**Show status**

```vela status```

**List applications**

```vela ls```

**Delete application**

```vela delete [appname]```

**Show logs**

```vela logs [appname]```

**Execute command**

```vela exec [appname] -- [command]```

# SYNOPSIS

**vela** _command_ [_options_] [_args_]

# PARAMETERS

**up**
> Deploy application.

**status**
> Show status.

**ls**
> List apps.

**delete**
> Remove app.

**logs**
> View logs.

**exec**
> Run command.

# DESCRIPTION

**vela** manages KubeVela apps. It's the CLI client.

Application deployment. OAM-based.

Kubernetes native. Cloud resources.

Traits and policies. Extend behavior.

Multi-cluster. Deploy anywhere.

# CAVEATS

KubeVela required. Kubernetes knowledge. OAM concepts.

# HISTORY

**vela** is the CLI for **KubeVela**, an application delivery platform based on Open Application Model.

# SEE ALSO

[kubectl](/man/kubectl)(1), [helm](/man/helm)(1), [argocd](/man/argocd)(1)
