# TLDR

**Compile file**

```v [file.v]```

**Run file**

```v run [file.v]```

**Build optimized**

```v -prod [file.v]```

**Format code**

```v fmt [file.v]```

**Start REPL**

```v repl```

**Test module**

```v test [module]```

# SYNOPSIS

**v** [_run_] [_-prod_] [_options_] _file_

# PARAMETERS

**run**
> Compile and run.

**-prod**
> Production build.

**fmt**
> Format code.

**repl**
> Interactive mode.

**test**
> Run tests.

**-o** _FILE_
> Output name.

# DESCRIPTION

**v** compiles V language. It's the V compiler.

Fast compilation. Near-instant builds.

Simple syntax. C-like but simpler.

Memory safety. No null pointers.

C interop. Call C directly.

# CAVEATS

Young language. Ecosystem growing. V-specific.

# HISTORY

**V** was created by **Alexander Medvednikov** as a simple, fast, and safe systems programming language.

# SEE ALSO

[gcc](/man/gcc)(1), [go](/man/go)(1), [zig](/man/zig)(1)
