# TLDR

**List installed versions**

```u3d list```

**Install Unity version**

```u3d install [2022.3.0f1]```

**Run Unity**

```u3d run -u [2022.3.0f1]```

**Available versions**

```u3d available```

**Uninstall version**

```u3d uninstall [2022.3.0f1]```

# SYNOPSIS

**u3d** _command_ [_-u version_] [_options_]

# PARAMETERS

**list**
> Installed versions.

**install**
> Install version.

**available**
> Show available.

**run**
> Run Unity.

**uninstall**
> Remove version.

**-u** _VERSION_
> Unity version.

# DESCRIPTION

**u3d** manages Unity installations. It's a version manager.

Multiple versions. Install side by side.

Command-line builds. CI/CD ready.

Cross-platform. macOS, Linux, Windows.

License management. Activate headless.

# CAVEATS

Unity-specific. Large downloads. License required.

# HISTORY

**u3d** was created for managing Unity Editor installations, especially useful in CI/CD environments.

# SEE ALSO

[unity](/man/unity)(1), [brew](/man/brew)(1)
