# TLDR

**Run application**

```tye run```

**Run with dashboard**

```tye run --dashboard```

**Build project**

```tye build```

**Deploy to Kubernetes**

```tye deploy```

**Initialize config**

```tye init```

# SYNOPSIS

**tye** _command_ [_--dashboard_] [_options_]

# PARAMETERS

**run**
> Run application.

**build**
> Build containers.

**deploy**
> Deploy to K8s.

**init**
> Create tye.yaml.

**--dashboard**
> Enable dashboard.

**--port** _PORT_
> Dashboard port.

# DESCRIPTION

**tye** runs microservices. It's a development tool.

Multi-service orchestration. Run together.

Dashboard included. Service monitoring.

Kubernetes deployment. Easy deploy.

.NET focused. Service discovery.

# CAVEATS

.NET focused. Experimental tool. Microsoft project.

# HISTORY

**Tye** was created by **Microsoft** as an experimental tool for developing and deploying microservices in .NET.

# SEE ALSO

[docker-compose](/man/docker-compose)(1), [dotnet](/man/dotnet)(1), [kubectl](/man/kubectl)(1)
