# TLDR

**Show directory tree**

```tre```

**Show with hidden**

```tre -a```

**Limit depth**

```tre -L [2]```

**With editor integration**

```tre -e```

**Specific directory**

```tre [path/to/directory]```

**Portable paths**

```tre -p```

# SYNOPSIS

**tre** [_-a_] [_-L depth_] [_-e_] [_options_] [_path_]

# PARAMETERS

**-a**
> Include hidden.

**-L** _DEPTH_
> Maximum depth.

**-e**
> Editor integration.

**-p**
> Portable paths.

**-s**
> Simple output.

**--help**
> Show help.

# DESCRIPTION

**tre** shows directory trees. It's a modern tree replacement.

Editor integration. Open file by number.

Portable paths. Copy-paste ready.

Clean output. Modern design.

Gitignore aware. Respects ignores.

# CAVEATS

Different from tree. Rust implementation. Editor feature unique.

# HISTORY

**tre** was created as a modern replacement for tree with editor integration for quick file access.

# SEE ALSO

[tree](/man/tree)(1), [exa](/man/exa)(1), [fd](/man/fd)(1)
