# TLDR

**Show page**

```tldrl [command]```

**Update cache**

```tldrl --update```

**List all pages**

```tldrl --list```

**Show platform-specific**

```tldrl --platform [linux] [command]```

**Search pages**

```tldrl --search "[keyword]"```

# SYNOPSIS

**tldrl** [_--update_] [_--platform os_] [_options_] [_command_]

# PARAMETERS

**--update**
> Update cache.

**--list**
> List pages.

**--platform** _OS_
> Platform filter.

**--search** _TERM_
> Search pages.

**--help**
> Show help.

# DESCRIPTION

**tldrl** displays TLDR pages. It's a TLDR client.

Simplified man pages. Practical examples.

Local caching. Offline access.

Platform support. OS-specific pages.

Fast lookups. Rust implementation.

# CAVEATS

Internet for updates. Cache needs refresh. Not official tldr client.

# HISTORY

**tldrl** is a Rust implementation of a TLDR client for accessing community-maintained simplified man pages.

# SEE ALSO

[tldr](/man/tldr)(1), [man](/man/man)(1), [cheat](/man/cheat)(1)
