# TLDR

**Start an interactive** Python shell

```python3```

**Execute a Python script**

```python3 [script.py]```

**Execute a Python command**

```python3 -c "[print('Hello')]"```

**Run a module** as a script

```python3 -m [module_name]```

**Start a simple HTTP server** in the current directory

```python3 -m http.server [8000]```

**Install a package** using pip

```python3 -m pip install [package]```

**Check Python version**

```python3 --version```

# SYNOPSIS

**python3** [_-BdEhiIOqsSuvVWx?_] [_-c command_] [_-m module_] [_-X option_] [_script_] [_args_]

# PARAMETERS

**-c** _command_
> Execute Python code passed as a string

**-m** _module_
> Run library module as a script

**-i**
> Inspect interactively after running script

**-B**
> Don't write .pyc bytecode files

**-O**
> Optimize generated bytecode

**-OO**
> Remove docstrings in addition to -O optimizations

**-q**
> Don't print version and copyright on startup

**-s**
> Don't add user site-packages to sys.path

**-S**
> Don't import the site module

**-u**
> Unbuffered binary stdout and stderr

**-v**
> Verbose mode (trace import statements)

**-V**, **--version**
> Print Python version and exit

**-W** _arg_
> Warning control (error, ignore, always, default, module, once)

**-X** _option_
> Set implementation-specific option

**-h**, **--help**
> Print help message and exit

**-E**
> Ignore PYTHON* environment variables

# DESCRIPTION

**python3** is the interpreter for the Python programming language, version 3.x. It executes Python code either interactively or from script files, supporting both procedural and object-oriented programming paradigms.

When invoked without arguments, it starts an interactive REPL (Read-Eval-Print Loop) for experimenting with Python code. With a script file as argument, it executes the script. The **-m** option allows running installed modules as scripts, enabling functionality like starting HTTP servers, running tests, or managing packages with pip.

Python 3 is the current major version of Python, featuring improved Unicode support, print as a function, integer division changes, and many other enhancements over Python 2 (which reached end-of-life in 2020).

# CAVEATS

On some systems, **python** may still refer to Python 2; use **python3** explicitly to ensure version 3. Virtual environments (**venv**) are recommended for project isolation. The Global Interpreter Lock (GIL) limits true multi-threaded parallelism. Scripts with Windows line endings may cause issues; use **dos2unix** if needed.

# HISTORY

Python was created by **Guido van Rossum** and first released in **1991**. Python 3.0 was released on **December 3, 2008**, introducing significant changes that broke backward compatibility with Python 2. The transition period lasted many years, with Python 2.7's end-of-life officially on **January 1, 2020**. Python has grown to become one of the world's most popular programming languages, widely used in web development, data science, artificial intelligence, scripting, and education.

# SEE ALSO

[pip](/man/pip)(1), [ipython](/man/ipython)(1), [virtualenv](/man/virtualenv)(1), [perl](/man/perl)(1), [ruby](/man/ruby)(1)
