# TLDR

**Run Python script**

```python [script.py]```

**Start interactive REPL**

```python```

**Execute code**

```python -c "[print('Hello')]"```

**Run module**

```python -m [module]```

**Start HTTP server**

```python -m http.server [8080]```

**Check syntax**

```python -m py_compile [script.py]```

# SYNOPSIS

**python** [_options_] [_script_] [_args_]

# PARAMETERS

_SCRIPT_
> Python script to run.

_ARGS_
> Script arguments.

**-c** _CODE_
> Execute code string.

**-m** _MODULE_
> Run library module.

**-i**
> Interactive after script.

**-O**
> Optimize bytecode.

**-V**
> Show version.

**-u**
> Unbuffered output.

# DESCRIPTION

**python** is the Python interpreter. General-purpose programming language.

The tool runs Python code. Scripting and application development.

python executes Python.

# CAVEATS

Python 2 vs 3 differences. Use python3 for Python 3.

# HISTORY

Python was created by **Guido van Rossum** in 1991.

# SEE ALSO

[python3](/man/python3)(1), [pip](/man/pip)(1), [pydoc](/man/pydoc)(1)

