# TLDR

**List Node versions (PowerShell)**

```ps-nvm list```

**Install Node version**

```ps-nvm install [18.0.0]```

**Use specific version**

```ps-nvm use [18.0.0]```

**Set default version**

```ps-nvm default [18.0.0]```

# SYNOPSIS

**ps-nvm** _command_ [_version_]

# PARAMETERS

**list**
> List installed versions.

**install** _VERSION_
> Install Node version.

**use** _VERSION_
> Switch to version.

**default** _VERSION_
> Set default version.

**uninstall** _VERSION_
> Remove version.

# DESCRIPTION

**ps-nvm** is Node Version Manager for PowerShell. Windows node management.

The tool manages Node.js versions. PowerShell native.

ps-nvm switches Node versions.

# CAVEATS

PowerShell only. Windows alternative to nvm.

# HISTORY

ps-nvm was created for **PowerShell** Node.js version management.

# SEE ALSO

[nvm](/man/nvm)(1), [node](/man/node)(1), [volta](/man/volta)(1)

