# TLDR

**Install dependencies**

```npm install```

**Install package**

```npm install [package]```

**Install globally**

```npm install -g [package]```

**Install dev dependency**

```npm install -D [package]```

**Run script**

```npm run [script-name]```

**Start application**

```npm start```

**Run tests**

```npm test```

**Update packages**

```npm update```

**Initialize project**

```npm init```

# SYNOPSIS

**npm** [_command_] [_options_]

# PARAMETERS

_COMMAND_
> npm command.

**install**
> Install packages.

**uninstall**
> Remove packages.

**run** _SCRIPT_
> Run package script.

**update**
> Update packages.

**init**
> Create package.json.

**-g**
> Global installation.

**--help**
> Display help information.

# DESCRIPTION

**npm** is the Node Package Manager. It manages JavaScript packages and dependencies.

The tool handles package.json. Largest software registry in the world.

npm is Node package manager.

# CAVEATS

Requires Node.js. package-lock.json for determinism. Network dependent.

# HISTORY

npm was created by **Isaac Schlueter** in 2010 and is the default package manager for Node.js.

# SEE ALSO

[npx](/man/npx)(1), [yarn](/man/yarn)(1), [pnpm](/man/pnpm)(1)

