# TLDR

**Build project**

```ninja```

**Build specific target**

```ninja [target]```

**Build with multiple jobs**

```ninja -j [8]```

**Clean build**

```ninja -t clean```

**Dry run**

```ninja -n```

**Verbose output**

```ninja -v```

**Use specific build file**

```ninja -f [build.ninja]```

**Show build graph**

```ninja -t graph [target]```

# SYNOPSIS

**ninja** [_options_] [_targets_]

# PARAMETERS

_TARGETS_
> Build targets.

**-j** _N_
> Parallel jobs.

**-f** _FILE_
> Build file.

**-v**
> Verbose mode.

**-n**
> Dry run.

**-t** _TOOL_
> Run subtool.

**--help**
> Display help information.

# DESCRIPTION

**ninja** is a small, fast build system. It focuses on speed and correctness.

The tool processes build.ninja files. Usually generated by CMake or Meson.

ninja is fast build system.

# CAVEATS

Build files usually generated. Simpler than Make. Designed for speed.

# HISTORY

Ninja was created by **Evan Martin** at Google for building Chrome, released in 2012.

# SEE ALSO

[cmake](/man/cmake)(1), [meson](/man/meson)(1), [make](/man/make)(1)

