# TLDR

**Play MP3 file**

```mpg321 [file.mp3]```

**Play multiple files**

```mpg321 [file1.mp3] [file2.mp3]```

**Play from URL**

```mpg321 [http://example.com/audio.mp3]```

**Play with shuffle**

```mpg321 -z [*.mp3]```

**Play with volume adjustment**

```mpg321 -g [50] [file.mp3]```

**Quiet mode** (no output)

```mpg321 -q [file.mp3]```

**Output to WAV file**

```mpg321 -w [output.wav] [input.mp3]```

**Loop playback**

```mpg321 --loop [3] [file.mp3]```

# SYNOPSIS

**mpg321** [_-w output.wav_] [_-g gain_] [_-z_] [_-q_] [_options_] _files_

# PARAMETERS

**-w** _FILE_
> Output to WAV file instead of playing.

**-g** _GAIN_
> Audio gain (0-100).

**-z**
> Shuffle playlist.

**-q**, **--quiet**
> Quiet mode.

**--loop** _N_
> Loop playback N times.

**-@** _FILE_
> Read playlist from file.

**-o** _DRIVER_
> Audio output driver.

**-a** _DEVICE_
> Audio device.

**-b** _SIZE_
> Buffer size in kilobytes.

**-r**
> Use remote control interface.

**-s**
> Output to stdout (for piping).

**-v**
> Verbose output.

# DESCRIPTION

**mpg321** is a command-line MP3 player, a free clone of mpg123. It decodes and plays MPEG audio files using the libmad library.

The player supports local files, playlists, and HTTP streams. Shuffle mode randomizes playback order. Loop mode repeats tracks or playlists.

WAV output decodes MP3 to uncompressed audio, useful for burning CDs or converting formats. Combined with pipes, it can feed audio to other programs.

The remote control mode accepts commands on stdin, enabling integration with front-end applications. Commands control playback, seeking, and volume.

Gain adjustment scales the audio output. Values above 100 may cause clipping. The setting helps normalize volume across tracks.

# CAVEATS

MP3 only - no other formats. Some streams may not work. Audio quality limited by libmad decoder. No gapless playback.

# HISTORY

**mpg321** was created by **Joe Drew** in **2001** as a free replacement for mpg123 during a time when mpg123's license was unclear. It used the libmad decoder which was clearly free software. When mpg123 became LGPL, both players continued development.

# SEE ALSO

[mpg123](/man/mpg123)(1), [mplayer](/man/mplayer)(1), [mpv](/man/mpv)(1), [sox](/man/sox)(1)
