# TLDR

**Play** MP3 files

```mpg123 [path/to/file1.mp3] [path/to/file2.mp3]```

Play MP3 from **stdin**

```cat [file.mp3] | mpg123 -```

Play with **shuffle**

```mpg123 -z [path/to/*.mp3]```

**Loop** playback

```mpg123 --loop [3] [path/to/file.mp3]```

Output to **WAV file**

```mpg123 -w [output.wav] [input.mp3]```

Play from **URL**

```mpg123 [http://example.com/stream.mp3]```

# INTERACTIVE CONTROLS

**f** - Forward to next song
**b** - Back to beginning of song
**s** - Stop/replay current file
**.** - Fast forward
**,** - Rewind
**+/-** - Volume up/down
**q** - Quit

# SYNOPSIS

**mpg123** [_options_] _file-or-URL_...

# PARAMETERS

**-o, --output _module_**
> Select audio output module

**-a, --audiodevice _device_**
> Specify audio device

**-w, --wav _file_**
> Write output to WAV file

**-s, --stdout**
> Write raw audio to stdout

**-r, --rate _rate_**
> Set sample rate

**-m, --mono**
> Decode to mono

**-z, --shuffle**
> Shuffle playlist

**-Z, --random**
> Continuous random playback

**--loop _count_**
> Repeat playback count times

**-@, --list _file_**
> Read playlist from file

**-k _frames_**
> Skip initial frames

**-n _frames_**
> Decode only specified number of frames

**-C, --control**
> Enable terminal control keys

**-q, --quiet**
> Suppress output messages

**-v, --verbose**
> Increase verbosity

**-t, --test**
> Test decode without audio output

**-b, --buffer _size_**
> Audio buffer size in KB

**-E, --equalizer _file_**
> Apply 32-band equalizer from file

# DESCRIPTION

**mpg123** is a fast, free console MPEG audio player supporting layers 1, 2, and 3. It plays local files, reads from stdin, and streams from HTTP URLs. The player supports various audio output modules including ALSA, PulseAudio, and OSS.

Terminal control mode (-C) enables interactive playback control with keyboard commands for seeking, volume adjustment, and track navigation.

# CAVEATS

MPEG audio decoding is CPU-intensive, especially for layer 3. Network streaming requires bandwidth matching or exceeding the audio bitrate. Since version 1.26.0, returns non-zero exit code if any track fails to parse.

# HISTORY

**mpg123** was originally written by **Michael Hipp** in the mid-1990s and has been continuously developed since. It remains one of the most efficient console MP3 players for Unix-like systems.

# SEE ALSO

[aplay](/man/aplay)(1), [mocp](/man/mocp)(1), [ffplay](/man/ffplay)(1)
