# TLDR

**Create new app**

```npx ignite-cli new [MyApp]```

**Generate component**

```npx ignite-cli generate component [Header]```

**Generate screen**

```npx ignite-cli generate screen [Login]```

**Generate model**

```npx ignite-cli generate model [User]```

**Doctor check**

```npx ignite-cli doctor```

# SYNOPSIS

**ignite** _command_ [_options_]

# PARAMETERS

_COMMAND_
> Subcommand to run.

**new**
> Create new app.

**generate**
> Generate code.

**doctor**
> Check environment.

**--help**
> Display help information.

# DESCRIPTION

**Ignite** is a CLI for React Native development. It provides boilerplate generation and project scaffolding with best practices.

The tool creates apps with MobX-State-Tree, TypeScript, and testing setup. It generates components, screens, and models.

Ignite scaffolds React Native apps.

# CAVEATS

React Native specific. Node.js required. Opinionated architecture.

# HISTORY

Ignite was created by **Infinite Red** as a React Native boilerplate and CLI tool.

# SEE ALSO

[npx](/man/npx)(1), [react-native](/man/react-native)(1), [expo](/man/expo)(1)
