# TLDR

**Install a library**

```haxelib install [library]```

**Install specific version**

```haxelib install [library] [version]```

**Install from zip file**

```haxelib install [file.zip]```

**Update a library**

```haxelib update [library]```

**Update all libraries**

```haxelib upgrade```

**List installed libraries**

```haxelib list```

**Search for libraries**

```haxelib search [query]```

**Remove a library**

```haxelib remove [library]```

# SYNOPSIS

**haxelib** _command_ [_arguments_]

# SUBCOMMANDS

**install** _name_ [_version_]
> Install a library.

**update** _name_
> Update a single library.

**upgrade**
> Update all installed libraries.

**remove** _name_
> Remove a library.

**list**
> List installed libraries.

**search** _query_
> Search for libraries.

**info** _name_
> Show library information.

**run** _name_
> Run a library's run script.

# DESCRIPTION

**haxelib** is the package manager for the Haxe programming language. It allows searching, installing, upgrading, and removing libraries from the haxelib repository at lib.haxe.org. Libraries can be installed from the repository, git repositories, or local zip files.

# SEE ALSO

[haxe](/man/haxe)(1), [npm](/man/npm)(1)

