# TLDR

**List projects**

```gcloud projects list```

**Create a project**

```gcloud projects create [project_id]```

**Describe a project**

```gcloud projects describe [project_id]```

**Delete a project**

```gcloud projects delete [project_id]```

**Set IAM policy**

```gcloud projects set-iam-policy [project_id] [policy.json]```

# SYNOPSIS

**gcloud** **projects** _command_ [_options_]

# SUBCOMMANDS

**list**
> List projects.

**create**
> Create a project.

**describe**
> Describe a project.

**delete**
> Delete a project.

**get-iam-policy**
> Get IAM policy.

**set-iam-policy**
> Set IAM policy.

**add-iam-policy-binding**
> Add IAM binding.

**undelete**
> Restore deleted project.

# DESCRIPTION

**gcloud projects** manages Google Cloud projects. Projects are the top-level organizing entity for resources and IAM policies.

# SEE ALSO

[gcloud](/man/gcloud)(1), [gcloud-config](/man/gcloud-config)(1)

