# TLDR

**Build project**

```dub build```

**Run project**

```dub run```

**Initialize new project**

```dub init [name]```

**Add dependency**

```dub add [package]```

**Update dependencies**

```dub upgrade```

**Run tests**

```dub test```

**Build documentation**

```dub build --build=docs```

**Fetch dependencies only**

```dub fetch [package]```

# SYNOPSIS

**dub** _command_ [_options_]

# SUBCOMMANDS

**build**
> Build project.

**run**
> Build and run.

**test**
> Run unit tests.

**init**
> Initialize new project.

**add**
> Add dependency.

**remove**
> Remove dependency.

**upgrade**
> Upgrade dependencies.

**fetch**
> Fetch package.

**clean**
> Clean build artifacts.

**describe**
> Show project description.

# DESCRIPTION

**dub** is the D language package manager and build tool. Manages dependencies, builds projects, and runs tests for D programming language projects.

# SEE ALSO

[dmd](/man/dmd)(1), [ldc](/man/ldc)(1)

