# TLDR

**Mark task as done** (Taskwarrior)

```task [id] done```

**Complete multiple tasks**

```task [1] [2] [3] done```

# SYNOPSIS

**done** [_options_]

# DESCRIPTION

**done** is commonly used as a subcommand or keyword in task management systems to mark tasks as completed. In Taskwarrior, "task done" marks a task complete. In fish shell, it ends a for/while loop.

The specific behavior depends on the context and tool. In shell scripting (fish), "done" terminates loop constructs. In task managers, it indicates task completion.

This entry documents the general concept as various tools implement "done" functionality differently.

# CAVEATS

Behavior varies by tool/shell. May conflict with function names. Context-dependent semantics.

# SEE ALSO

[task](/man/task)(1), [fish](/man/fish)(1), [bash](/man/bash)(1)
