# TLDR

**List volumes**

```docker volume ls```

**Create a volume**

```docker volume create [name]```

**Inspect a volume**

```docker volume inspect [volume]```

**Remove a volume**

```docker volume rm [volume]```

**Remove unused volumes**

```docker volume prune```

**Create with driver options**

```docker volume create --driver local --opt type=nfs --opt o=addr=[host],rw --opt device=:[path] [name]```

# SYNOPSIS

**docker** **volume** _command_ [_options_]

# SUBCOMMANDS

**ls**
> List volumes.

**create**
> Create a volume.

**inspect**
> Display detailed information.

**rm**
> Remove volumes.

**prune**
> Remove unused volumes.

# DESCRIPTION

**docker volume** manages Docker volumes. Volumes persist data independently of containers and are the preferred mechanism for persisting data generated by containers.

# SEE ALSO

[docker-run](/man/docker-run)(1), [docker-system-prune](/man/docker-system-prune)(1)

