# TLDR

**Start interactive** JavaScript shell

```d8```

**Run a JavaScript file**

```d8 [script.js]```

**Execute code from command** line

```d8 -e "[console.log('Hello')]"```

**Run with specific V8** flags

```d8 --harmony [script.js]```

**Enable all experimental** features

```d8 --experimental [script.js]```

**Print bytecode** for analysis

```d8 --print-bytecode [script.js]```

**Profile execution** with tick processor

```d8 --prof [script.js]```

# SYNOPSIS

**d8** [_V8-options_] [_script.js_] [_--_] [_arguments_]

# PARAMETERS

_SCRIPT_
> JavaScript file to execute.

**-e** _CODE_
> Execute JavaScript code string.

**--harmony**
> Enable staged harmony features.

**--experimental**
> Enable experimental features.

**--print-bytecode**
> Print generated bytecode.

**--trace-opt**
> Trace optimization decisions.

**--prof**
> Generate profiling data.

**--allow-natives-syntax**
> Allow V8 native function calls.

**--help**
> Display V8 flags and options.

**--**
> Separator between V8 flags and script arguments.

# DESCRIPTION

**d8** is the V8 JavaScript engine's developer shell, providing a minimal JavaScript execution environment. It's used for testing JavaScript code, benchmarking, debugging V8 internals, and developing the V8 engine itself.

Unlike Node.js or browser environments, d8 provides direct access to V8 without additional APIs. It includes special functions for profiling, optimization analysis, and debugging that aren't available in production environments.

d8 is valuable for understanding how V8 optimizes JavaScript code. Flags like **--print-bytecode** and **--trace-opt** reveal the engine's internal operations, useful for performance-sensitive code optimization.

# CAVEATS

d8 is primarily a developer tool, not for production use. It lacks standard APIs like setTimeout, fetch, or file system access. Building d8 requires compiling V8 from source. Behavior may vary between V8 versions.

# HISTORY

d8 is the debugging shell for **V8**, Google's JavaScript engine created in **2008** for the Chrome browser. Named after V8's internal development name "v8" + "d" for debug, it provides low-level access to the engine's capabilities for testing and development.

# SEE ALSO

[node](/man/node)(1), [deno](/man/deno)(1), [jsc](/man/jsc)(1)
