# TLDR

**Run with default options**

```./configure```

**Set installation prefix**

```./configure --prefix=[/usr/local]```

**Enable or disable feature**

```./configure --enable-[feature] --disable-[other]```

**With specific dependency path**

```./configure --with-[lib]=[/path/to/lib]```

**Show all options**

```./configure --help```

**Build for different host**

```./configure --host=[x86_64-linux-gnu]```

**Set compiler and flags**

```CC=[gcc] CFLAGS="[-O2]" ./configure```

# SYNOPSIS

**./configure** [_options_] [_VAR=VALUE_...]

# DESCRIPTION

**configure** is a shell script generated by GNU Autotools that prepares software for building on the current system. It detects system capabilities, checks for dependencies, and generates Makefiles tailored to the environment.

The script probes for compilers, libraries, headers, and system features, storing results in config.h and substituting values into Makefile.in templates. This enables portable software building across different Unix-like systems.

# PARAMETERS

**--prefix=** _path_
> Installation root directory.

**--exec-prefix=** _path_
> Architecture-dependent files location.

**--bindir=** _path_
> User executables directory.

**--libdir=** _path_
> Libraries directory.

**--includedir=** _path_
> Header files directory.

**--enable-** _feature_
> Enable optional feature.

**--disable-** _feature_
> Disable feature.

**--with-** _package_
> Use external package.

**--without-** _package_
> Don't use package.

**--host=** _triplet_
> Cross-compile for target.

**--build=** _triplet_
> Build system type.

**--help**
> Show available options.

# ENVIRONMENT VARIABLES

**CC**: C compiler command
**CXX**: C++ compiler command
**CFLAGS**: C compiler flags
**LDFLAGS**: Linker flags
**PKG_CONFIG_PATH**: pkg-config search path

# CAVEATS

Script must be regenerated if autoconf files change. Cross-compilation requires careful setup. Some packages have many options to navigate. Build may fail if dependencies are missing.

# HISTORY

**configure** scripts are generated by **GNU Autoconf**, created by **David MacKenzie** starting in **1991**. Autoconf addressed the challenge of portable software across diverse Unix systems. The configure/make/make install pattern became standard for Unix software distribution. While newer build systems exist, Autotools remains widely used.

# SEE ALSO

[make](/man/make)(1), [autoconf](/man/autoconf)(1), [automake](/man/automake)(1), [pkg-config](/man/pkg-config)(1)
