# TLDR

**Upload coverage report**

```codecov```

**Upload with specific token**

```codecov -t [token]```

**Upload specific file**

```codecov -f [coverage.xml]```

**Upload with custom flags**

```codecov -F [unittests]```

**Upload for specific commit**

```codecov -C [commit_sha]```

**Dry run without uploading**

```codecov -d```

**Upload with verbose output**

```codecov -v```

# SYNOPSIS

**codecov** [_options_]

# PARAMETERS

**-t**, **--token** _token_
> Repository upload token.

**-f**, **--file** _file_
> Coverage report file to upload.

**-F**, **--flag** _name_
> Flag to group coverage (e.g., unittests, integration).

**-C**, **--sha** _sha_
> Commit SHA to associate with upload.

**-B**, **--branch** _name_
> Branch name for upload.

**-P**, **--pr** _number_
> Pull request number.

**-b**, **--build** _id_
> CI build number.

**-n**, **--name** _name_
> Custom upload name.

**-d**, **--dry-run**
> Don't upload, show what would be sent.

**-v**, **--verbose**
> Verbose output.

**-Z**, **--fail-on-error**
> Exit with non-zero on upload failure.

# DESCRIPTION

**Codecov** is a code coverage reporting service that aggregates coverage data from test runs and provides insights through dashboards and pull request comments. The CLI tool uploads coverage reports generated by testing frameworks to the Codecov service.

The uploader automatically detects CI environments (GitHub Actions, GitLab CI, Jenkins, etc.) and extracts commit, branch, and build information. It searches for coverage files in common formats (lcov, cobertura, jacoco, etc.) and uploads them.

Coverage flags allow separating different test types (unit, integration, e2e) for granular analysis. The service tracks coverage over time and comments on pull requests with coverage changes.

# CAVEATS

Requires a Codecov account and repository token (or tokenless upload for public repos). Coverage format must be supported (lcov, cobertura, clover, etc.). Large coverage files may take time to process. Private repositories require authentication.

# HISTORY

Codecov was founded in **2014** by **Steve Peak** and **Eli Hooten** to provide better code coverage analytics for development teams. The service gained popularity as a complement to CI/CD pipelines, providing visual coverage tracking and pull request integration. In **2022**, Codecov was acquired by **Sentry**. The uploader CLI is open-source and supports all major CI platforms.

# SEE ALSO

[coveralls](/man/coveralls)(1), [lcov](/man/lcov)(1), [gcov](/man/gcov)(1)
