# TLDR

**Analyze block trace** data

```btt -i [sda.blktrace.0]```

**Analyze with specific output prefix**

```btt -i [device.blktrace.0] -o [analysis]```

**Generate Q2C latency data**

```btt -i [trace.blktrace.0] -q [q2c_output]```

**Generate D2C latency data**

```btt -i [trace.blktrace.0] -d [d2c_output]```

**Analyze merged trace files**

```blkparse -i [sda] -d [merged.bin] && btt -i [merged.bin]```

**Verbose analysis**

```btt -i [trace.blktrace.0] -v```

# SYNOPSIS

**btt** [_options_] **-i** _trace_file_

# DESCRIPTION

**btt** (Block Trace Timeline) analyzes block layer trace data generated by blktrace. It produces statistical reports showing I/O latency distributions, throughput, and timing breakdowns across the block I/O stack.

The analysis breaks down request processing into stages: Q (queued), G (get request), I (inserted), M (merged), D (dispatched), C (completed). btt reports latencies between these stages to identify bottlenecks.

Output includes overall statistics, per-device breakdowns, and optional detailed timing files for each stage transition. This data is valuable for understanding storage performance characteristics and diagnosing latency issues.

# PARAMETERS

**-i** _file_
> Input trace file (from blkparse -d).

**-o** _prefix_
> Output file prefix.

**-q** _file_
> Write Q2C latency data.

**-d** _file_
> Write D2C latency data.

**-l** _file_
> Write per-IO latency data.

**-m** _file_
> Write D2D seek distance data.

**-B** _file_
> Write block number data.

**-v**
> Verbose output.

**-V**
> Version information.

**-a**
> Include all accounting.

**-M**
> Only display device mapping info.

# CAVEATS

Requires binary trace data from blkparse -d, not raw blktrace files. Large traces produce large analysis output. Timestamps must be synchronized for meaningful analysis. Output files can be plotted with gnuplot for visualization.

# HISTORY

**btt** was developed alongside **blktrace** by **Alan D. Brunelle** as part of the Linux block layer tracing infrastructure, included in the blktrace package since its introduction in Linux kernel **2.6.17** (**2006**). It provides the analytical companion to blktrace's data collection capabilities, enabling detailed performance analysis of the block I/O subsystem.

# SEE ALSO

[blktrace](/man/blktrace)(8), [blkparse](/man/blkparse)(1), [iowatcher](/man/iowatcher)(1), [iostat](/man/iostat)(1)
