# TLDR

**Open** Brave browser

```brave```

**Open** URL

```brave [https://example.com]```

**Incognito** mode

```brave --incognito [https://example.com]```

**Open** in new window

```brave --new-window [https://example.com]```

# SYNOPSIS

**brave** [_options_] [_url_]

# DESCRIPTION

**brave** is a privacy-focused web browser built on Chromium. It blocks ads and trackers by default, includes a built-in cryptocurrency wallet, and rewards users with BAT tokens for viewing privacy-respecting ads.

The browser emphasizes speed, privacy, and security while maintaining compatibility with Chrome extensions.

# PARAMETERS

**--incognito**
> Open in incognito mode

**--new-window**
> Open in new window

**--new-tab** _url_
> Open URL in new tab

**--app=**_url_
> Open as application

**--user-data-dir=**_dir_
> Use specific profile directory

**--proxy-server=**_server_
> Use proxy server

# FEATURES

- Built-in ad/tracker blocking
- HTTPS Everywhere
- Script blocking
- Fingerprint protection
- BAT cryptocurrency integration
- Brave Rewards
- Tor private tabs
- IPFS support
- Chrome extension compatibility

# PRIVACY FEATURES

- **Shields** - Block ads, trackers, scripts
- **Private tabs with Tor** - Anonymous browsing
- **No telemetry** - Privacy by default
- **Fingerprint randomization**

# BRAVE REWARDS

Opt-in system that rewards users with BAT (Basic Attention Token) for viewing privacy-respecting ads. Users can tip content creators.

# CAVEATS

Some websites may not work with aggressive blocking. BAT rewards availability varies by region. Sync requires Brave account. Some find built-in crypto features unnecessary. Based on Chromium (Google project).

# HISTORY

**Brave** was created by Brendan Eich (JavaScript creator, Mozilla co-founder) and launched in **2016** to provide privacy-focused browsing with an alternative ad model.

# SEE ALSO

[firefox](/man/firefox)(1), [chromium](/man/chromium)(1), [tor-browser](/man/tor-browser)(1)
